<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('damages')) {
            return;
        }

        Schema::create('damages', function (Blueprint $table) {
            $table->id();

            // Plain unsigned big ints + indexes, no FKs for now
            $table->unsignedBigInteger('vehicle_id')->index();
            $table->unsignedBigInteger('job_id')->nullable()->index();
            $table->unsignedBigInteger('reported_by_user_id')->nullable()->index();

            $table->timestamp('found_at')->nullable();

            $table->string('location')->nullable();        // e.g. "Front bumper"
            $table->string('type')->nullable();            // e.g. "Scratch", "Dent"
            $table->string('severity')->nullable();        // "minor", "moderate", "major"

            $table->integer('estimated_cost_cents')->nullable();
            $table->boolean('requires_repair')->default(true);
            $table->string('repair_status')->default('logged'); // logged, quoted, approved, in_progress, completed

            $table->boolean('is_preexisting')->default(false);

            $table->json('photos')->nullable();            // multiple file paths

            $table->text('notes')->nullable();

            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down(): void
    {
        if (! Schema::hasTable('damages')) {
            return;
        }

        Schema::dropIfExists('damages');
    }
};
