<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('communication_events', function (Blueprint $t) {
            $t->id();
            $t->foreignId('communication_id')->constrained()->cascadeOnDelete();
            $t->string('type', 64);              // sent, failed, delivered, opened, clicked...
            $t->json('payload')->nullable();     // any extra data
            $t->timestamp('occurred_at')->useCurrent();
            $t->timestamps();
        });
    }
    public function down(): void {
        Schema::dropIfExists('communication_events');
    }
};
