<?php
// database/migrations/2025_09_05_050058_create_job_access_tokens_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // If already created (e.g., in another deploy), do nothing.
        if (Schema::hasTable('job_access_tokens')) {
            return;
        }

        Schema::create('job_access_tokens', function (Blueprint $table) {
            $table->id();

            $table->foreignId('job_id')
                ->constrained('jobs')
                ->cascadeOnDelete();

            // Keep purpose short so it can be used safely in composite indexes on utf8mb4
            // Examples: "public-link", "webhook", "customer-portal"
            $table->string('purpose', 100)->index();

            // Token itself — length as needed by your generator (adjust if you use longer base64 strings)
            $table->string('token', 128)->unique();

            $table->timestamp('expires_at')->nullable()->index();
            $table->boolean('revoked')->default(false)->index();
            $table->json('meta')->nullable();

            $table->timestamps();

            // Common query: WHERE job_id = ? AND purpose = ?
            $table->index(['job_id', 'purpose'], 'job_access_tokens_job_id_purpose_index');
        });
    }

    public function down(): void
    {
        if (! Schema::hasTable('job_access_tokens')) {
            return;
        }

        Schema::dropIfExists('job_access_tokens');
    }
};
