<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (!Schema::hasColumn('jobs', 'psp_customer_id')) {
            Schema::table('jobs', function (Blueprint $table) {
                $table->string('psp_customer_id', 64)->nullable()->after('external_reference');
                $table->index('psp_customer_id');
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasColumn('jobs', 'psp_customer_id')) {
            Schema::table('jobs', function (Blueprint $table) {
                $table->dropIndex(['psp_customer_id']);
                $table->dropColumn('psp_customer_id');
            });
        }
    }
};
