<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('deposits', function (Blueprint $table) {
            // Amount lifecycle in cents (unsigned BIGINT to avoid overflow)
            if (!Schema::hasColumn('deposits', 'authorized_cents')) {
                $table->unsignedBigInteger('authorized_cents')->default(0)->after('amount_cents');
            }
            if (!Schema::hasColumn('deposits', 'captured_cents')) {
                $table->unsignedBigInteger('captured_cents')->default(0)->after('authorized_cents');
            }
            if (!Schema::hasColumn('deposits', 'released_cents')) {
                $table->unsignedBigInteger('released_cents')->default(0)->after('captured_cents');
            }

            // Timestamps for state changes
            if (!Schema::hasColumn('deposits', 'authorized_at')) {
                $table->timestamp('authorized_at')->nullable()->after('card_brand');
            }
            if (!Schema::hasColumn('deposits', 'captured_at')) {
                $table->timestamp('captured_at')->nullable()->after('authorized_at');
            }
            if (!Schema::hasColumn('deposits', 'released_at')) {
                $table->timestamp('released_at')->nullable()->after('captured_at');
            }
            if (!Schema::hasColumn('deposits', 'canceled_at')) {
                $table->timestamp('canceled_at')->nullable()->after('released_at');
            }

            // Optional: provider refs if not present
            if (!Schema::hasColumn('deposits', 'stripe_payment_intent')) {
                $table->string('stripe_payment_intent', 191)->nullable()->after('status');
            }
            if (!Schema::hasColumn('deposits', 'stripe_payment_method')) {
                $table->string('stripe_payment_method', 191)->nullable()->after('stripe_payment_intent');
            }
        });
    }

    public function down(): void
    {
        Schema::table('deposits', function (Blueprint $table) {
            foreach ([
                'authorized_cents','captured_cents','released_cents',
                'authorized_at','captured_at','released_at','canceled_at',
                'stripe_payment_intent','stripe_payment_method',
            ] as $col) {
                if (Schema::hasColumn('deposits', $col)) {
                    $table->dropColumn($col);
                }
            }
        });
    }
};
