<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('deposits', function (Blueprint $table) {
            if (!Schema::hasColumn('deposits', 'authorized_at')) {
                $table->timestamp('authorized_at')->nullable()->index();
            }
            if (!Schema::hasColumn('deposits', 'planned_cancel_at')) {
                $table->timestamp('planned_cancel_at')->nullable()->index();
            }
            if (!Schema::hasColumn('deposits', 'released_at')) {
                $table->timestamp('released_at')->nullable()->index();
            }
            if (!Schema::hasColumn('deposits', 'last_reason')) {
                $table->string('last_reason')->nullable();
            }
            if (!Schema::hasColumn('deposits', 'status')) {
                $table->string('status')->default('authorized')->index();
            }
            if (!Schema::hasColumn('deposits', 'meta')) {
                $table->json('meta')->nullable();
            }
        });
    }

    public function down(): void
    {
        // no-op: keep columns (safe rollback not required)
    }
};
