<?php

// database/migrations/2025_09_14_000001_add_planned_cancel_to_deposits.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('deposits', function (Blueprint $t) {
            if (!Schema::hasColumn('deposits', 'authorized_at')) {
                $t->timestamp('authorized_at')->nullable()->index();
            }
            if (!Schema::hasColumn('deposits', 'planned_cancel_at')) {
                $t->timestamp('planned_cancel_at')->nullable()->index();
            }
        });
    }

    public function down(): void
    {
        Schema::table('deposits', function (Blueprint $t) {
            if (Schema::hasColumn('deposits', 'planned_cancel_at')) {
                $t->dropColumn('planned_cancel_at');
            }
            if (Schema::hasColumn('deposits', 'authorized_at')) {
                $t->dropColumn('authorized_at');
            }
        });
    }
};
