<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (! Schema::hasTable('bookings')) return;

        Schema::table('bookings', function (Blueprint $t) {
            if (! Schema::hasColumn('bookings', 'portal_token')) {
                // 191 works with utf8mb4 for unique indexes
                $t->string('portal_token', 191)->nullable()->unique()->after('currency');
            }
            if (! Schema::hasColumn('bookings', 'reference')) {
                // your insert shows `reference` too — add if missing
                $t->string('reference', 191)->nullable()->after('portal_token');
            }
        });
    }

    public function down(): void
    {
        if (! Schema::hasTable('bookings')) return;

        Schema::table('bookings', function (Blueprint $t) {
            if (Schema::hasColumn('bookings', 'portal_token')) {
                $t->dropUnique('bookings_portal_token_unique');
                $t->dropColumn('portal_token');
            }
            // only drop if you added it above and want reversible migrations
            // if (Schema::hasColumn('bookings', 'reference')) $t->dropColumn('reference');
        });
    }
};
