<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('jobs', function (Blueprint $table) {
            if (! Schema::hasColumn('jobs', 'payment_request_scheduled_at')) {
                // Place after updated_at if it exists; otherwise just add it.
                if (Schema::hasColumn('jobs', 'updated_at')) {
                    $table->timestamp('payment_request_scheduled_at')->nullable()->after('updated_at');
                } else {
                    $table->timestamp('payment_request_scheduled_at')->nullable();
                }
                // optional: $table->index('payment_request_scheduled_at', 'jobs_payment_request_scheduled_at_idx');
            }
        });
    }

    public function down(): void
    {
        Schema::table('jobs', function (Blueprint $table) {
            if (Schema::hasColumn('jobs', 'payment_request_scheduled_at')) {
                // optional: $table->dropIndex('jobs_payment_request_scheduled_at_idx');
                $table->dropColumn('payment_request_scheduled_at');
            }
        });
    }
};
