<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('jobs', function (Blueprint $table) {
            if (! Schema::hasColumn('jobs', 'payment_request_scheduled_at')) {
                $table->timestamp('payment_request_scheduled_at')->nullable()->after('updated_at');
                // optional index if you'll query by this:
                // $table->index('payment_request_scheduled_at', 'jobs_payment_request_scheduled_at_idx');
            }
        });
    }

    public function down(): void
    {
        Schema::table('jobs', function (Blueprint $table) {
            if (Schema::hasColumn('jobs', 'payment_request_scheduled_at')) {
                // $table->dropIndex('jobs_payment_request_scheduled_at_idx'); // if you added it
                $table->dropColumn('payment_request_scheduled_at');
            }
        });
    }
};
