<?php 

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        // If the table already exists, do nothing.
        if (Schema::hasTable('payment_links')) {
            return;
        }

        Schema::create('payment_links', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('payment_id');
            $table->unsignedBigInteger('tenant_id')->nullable();
            $table->string('public_token', 64);
            $table->timestamp('expires_at')->nullable();
            $table->timestamp('clicked_at')->nullable();
            $table->json('meta')->nullable();
            $table->timestamps();

            $table->index('payment_id');
            $table->index('tenant_id');
            $table->unique('public_token');
        });
    }

    public function down(): void
    {
        // leave empty to avoid dropping in prod
    }
};
