<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('payments', function (Blueprint $table) {
            if (!Schema::hasColumn('payments', 'provider'))            $table->string('provider')->nullable()->after('id');
            if (!Schema::hasColumn('payments', 'provider_mode'))       $table->string('provider_mode', 8)->nullable()->after('provider');
            if (!Schema::hasColumn('payments', 'provider_payment_id')) { $table->string('provider_payment_id', 191)->nullable()->after('provider_mode'); $table->index('provider_payment_id','payments_provider_payment_id_idx'); }
            if (!Schema::hasColumn('payments', 'provider_charge_id'))  { $table->string('provider_charge_id', 191)->nullable()->after('provider_payment_id'); $table->index('provider_charge_id','payments_provider_charge_id_idx'); }
            if (!Schema::hasColumn('payments', 'amount'))              $table->bigInteger('amount')->nullable()->after('provider_charge_id'); // cents
            if (!Schema::hasColumn('payments', 'currency'))            $table->string('currency', 3)->nullable()->after('amount');
            if (!Schema::hasColumn('payments', 'type'))                $table->string('type', 16)->default('oneoff')->after('currency');
            if (!Schema::hasColumn('payments', 'status'))              $table->string('status', 24)->default('created')->after('type');
            if (!Schema::hasColumn('payments', 'error_code'))          $table->string('error_code', 64)->nullable()->after('status');
            if (!Schema::hasColumn('payments', 'error_message'))       $table->text('error_message')->nullable()->after('error_code');
            if (!Schema::hasColumn('payments', 'settlement_ref'))      $table->string('settlement_ref', 191)->nullable()->after('error_message');
            if (!Schema::hasColumn('payments', 'meta'))                $table->json('meta')->nullable()->after('settlement_ref');
        });
    }

    public function down(): void
    {
        Schema::table('payments', function (Blueprint $table) {
            foreach (['meta','settlement_ref','error_message','error_code','status','type','currency','amount','provider_charge_id','provider_payment_id','provider_mode','provider'] as $col) {
                if (Schema::hasColumn('payments', $col)) $table->dropColumn($col);
            }
            try { DB::statement('ALTER TABLE payments DROP INDEX payments_provider_payment_id_idx'); } catch (\Throwable $e) {}
            try { DB::statement('ALTER TABLE payments DROP INDEX payments_provider_charge_id_idx'); } catch (\Throwable $e) {}
        });
    }
};
