<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('webhook_events', function (Blueprint $table) {
            $table->id();
            $table->string('provider', 32);
            $table->string('provider_event_id', 191)->nullable();
            $table->string('normalized_type', 64)->nullable();
            $table->foreignId('payment_id')->nullable()->constrained('payments')->nullOnDelete();
            $table->json('raw');
            $table->timestamp('processed_at')->nullable();
            $table->timestamps();
            $table->index(['provider','provider_event_id']);
        });
    }
    public function down(): void { Schema::dropIfExists('webhook_events'); }
};
