<?php

// database/migrations/xxxx_xx_xx_xxxxxx_ensure_payments_id_is_auto_increment.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration {
    public function up(): void
    {
        // Only run if column is INT and missing auto_increment
        $col = DB::selectOne("
            SELECT EXTRA AS extra, DATA_TYPE AS dt
            FROM information_schema.COLUMNS
            WHERE TABLE_SCHEMA = DATABASE()
              AND TABLE_NAME = 'payments'
              AND COLUMN_NAME = 'id'
            LIMIT 1
        ");
        if ($col && $col->dt === 'int' && ! str_contains(strtolower($col->extra ?? ''), 'auto_increment')) {
            DB::statement("ALTER TABLE payments MODIFY id INT(11) NOT NULL AUTO_INCREMENT");
        }
    }

    public function down(): void
    {
        // No-op (safe)
    }
};
