<?php
// database/migrations/2025_09_20_000001_add_gateway_columns_to_payments.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::table('payments', function (Blueprint $t) {
            if (!Schema::hasColumn('payments', 'provider'))   $t->string('provider', 50)->nullable()->index();
            if (!Schema::hasColumn('payments', 'provider_id'))$t->string('provider_id', 191)->nullable()->index();
        });
    }
    public function down(): void {
        Schema::table('payments', function (Blueprint $t) {
            if (Schema::hasColumn('payments', 'provider_id')) $t->dropColumn('provider_id');
            if (Schema::hasColumn('payments', 'provider'))    $t->dropColumn('provider');
        });
    }
};
