<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        // Add missing columns safely (idempotent/guarded style)
        if (! Schema::hasColumn('payments', 'gateway')) {
            Schema::table('payments', function (Blueprint $table) {
                $table->string('gateway', 32)->nullable()->index()->after('provider'); // adjust position if needed
            });
        }

        if (! Schema::hasColumn('payments', 'gateway_id')) {
            Schema::table('payments', function (Blueprint $table) {
                $table->string('gateway_id', 191)->nullable()->index()->after('gateway');
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasColumn('payments', 'gateway_id')) {
            Schema::table('payments', function (Blueprint $table) {
                $table->dropColumn('gateway_id');
            });
        }
        if (Schema::hasColumn('payments', 'gateway')) {
            Schema::table('payments', function (Blueprint $table) {
                $table->dropColumn('gateway');
            });
        }
    }
};
