<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (! Schema::hasTable('payment_links')) return;

        // Make tenant_id nullable even if it was created NOT NULL earlier.
        // Use raw SQL to avoid requiring doctrine/dbal.
        DB::statement('ALTER TABLE `payment_links` MODIFY `tenant_id` BIGINT UNSIGNED NULL');
    }

    public function down(): void
    {
        // Optional: revert to NOT NULL (only if your data is clean)
        // DB::statement('ALTER TABLE `payment_links` MODIFY `tenant_id` BIGINT UNSIGNED NOT NULL');
    }
};
