<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('payments', function (Blueprint $table) {
            if (! Schema::hasColumn('payments', 'deposit_confirmed_at')) {
                $table->timestamp('deposit_confirmed_at')->nullable()->after('status');
            }
            if (! Schema::hasColumn('payments', 'captured_at')) {
                $table->timestamp('captured_at')->nullable()->after('deposit_confirmed_at');
            }
        });
    }

    public function down(): void
    {
        Schema::table('payments', function (Blueprint $table) {
            if (Schema::hasColumn('payments', 'deposit_confirmed_at')) {
                $table->dropColumn('deposit_confirmed_at');
            }
            if (Schema::hasColumn('payments', 'captured_at')) {
                $table->dropColumn('captured_at');
            }
        });
    }
};
