<?php


use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        if (Schema::hasTable('payments')) {
            Schema::table('payments', function (Blueprint $t) {
                if (!Schema::hasColumn('payments','stripe_payment_intent_id')) {
                    $t->string('stripe_payment_intent_id', 191)->nullable()->index();
                }
                if (!Schema::hasColumn('payments','stripe_payment_method_id')) {
                    $t->string('stripe_payment_method_id', 191)->nullable()->index();
                }
                if (!Schema::hasColumn('payments','capture_method')) {
                    $t->string('capture_method', 32)->nullable()->index(); // e.g. 'manual'
                }
                if (!Schema::hasColumn('payments','authorized_at')) {
                    $t->timestamp('authorized_at')->nullable()->index();
                }
            });
        }
    }
    public function down(): void {
        if (Schema::hasTable('payments')) {
            Schema::table('payments', function (Blueprint $t) {
                foreach (['stripe_payment_intent_id','stripe_payment_method_id','capture_method','authorized_at'] as $c) {
                    if (Schema::hasColumn('payments',$c)) $t->dropColumn($c);
                }
            });
        }
    }
};
