<?php
// database/migrations/2025_09_27_000000_add_payload_hash_to_communication_events.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (Schema::hasTable('communication_events') && !Schema::hasColumn('communication_events', 'payload_hash')) {
            Schema::table('communication_events', function (Blueprint $table) {
                $table->string('payload_hash', 64)->nullable()->after('payload');
                $table->index(['payload_hash']);
                // If you often hit duplicates, consider:
                // $table->unique(['communication_id','payload_hash']);
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasTable('communication_events') && Schema::hasColumn('communication_events', 'payload_hash')) {
            Schema::table('communication_events', function (Blueprint $table) {
                $table->dropIndex(['payload_hash']);
                $table->dropColumn('payload_hash');
            });
        }
    }
};
