<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('payments', function (Blueprint $table) {
            if (! Schema::hasColumn('payments', 'one_off')) {
                $table->boolean('one_off')->default(false)->index();
            }
            if (! Schema::hasColumn('payments', 'charge_mode')) {
                // request_link | off_session
                $table->string('charge_mode', 32)->nullable()->index();
            }
            if (! Schema::hasColumn('payments', 'reason')) {
                $table->string('reason', 500)->nullable();
            }
        });
    }

    public function down(): void
    {
        Schema::table('payments', function (Blueprint $table) {
            if (Schema::hasColumn('payments', 'one_off')) {
                $table->dropColumn('one_off');
            }
            if (Schema::hasColumn('payments', 'charge_mode')) {
                $table->dropColumn('charge_mode');
            }
            if (Schema::hasColumn('payments', 'reason')) {
                $table->dropColumn('reason');
            }
        });
    }
};
