<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('attachments')) {
            Schema::create('attachments', function (Blueprint $table) {
                $table->id();

                // Manually define morph columns with safe length (<=191 for utf8mb4)
                $table->string('attachable_type', 160);   // shorter than 191 to be extra safe
                $table->unsignedBigInteger('attachable_id');
                $table->index(['attachable_type', 'attachable_id'], 'attachments_attachable_index');

                $table->string('disk')->default(config('filesystems.default', 'public'));
                $table->string('path');
                $table->string('original_name')->nullable();
                $table->string('mime')->nullable();
                $table->unsignedBigInteger('size_bytes')->nullable();
                $table->timestamps();
            });
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('attachments');
    }
};
