<?php
// database/migrations/2025_09_27_000003_add_one_off_to_payments.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::table('payments', function (Blueprint $table) {
            if (!Schema::hasColumn('payments', 'one_off')) {
                $table->boolean('one_off')->default(false)->after('type');
            }
        });
    }

    public function down(): void {
        Schema::table('payments', function (Blueprint $table) {
            $table->dropColumn('one_off');
        });
    }
};
