<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (Schema::hasTable('payments') && ! Schema::hasColumn('payments', 'psp')) {
            Schema::table('payments', function (Blueprint $table) {
                // PSP = Payment Service Provider (e.g., 'stripe', 'manual', 'windcave', etc.)
                $table->string('psp')->nullable()->after('id');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasTable('payments') && Schema::hasColumn('payments', 'psp')) {
            Schema::table('payments', function (Blueprint $table) {
                $table->dropColumn('psp');
            });
        }
    }
};
