<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('payments', function (Blueprint $t) {
            if (!Schema::hasColumn('payments', 'psp')) {
                $t->string('psp')->nullable()->after('status'); // 'stripe'
            }
            if (!Schema::hasColumn('payments', 'stripe_payment_intent_id')) {
                $t->string('stripe_payment_intent_id')->nullable()->after('psp');
            }
        });

        // Unique across PSP + PI (prevents dupes when BOTH are set)
        Schema::table('payments', function (Blueprint $t) {
            $t->unique(['psp', 'stripe_payment_intent_id'], 'payments_psp_pi_unique');
        });
    }

    public function down(): void
    {
        Schema::table('payments', function (Blueprint $t) {
            $t->dropUnique('payments_psp_pi_unique');
            if (Schema::hasColumn('payments', 'stripe_payment_intent_id')) $t->dropColumn('stripe_payment_intent_id');
            if (Schema::hasColumn('payments', 'psp')) $t->dropColumn('psp');
        });
    }
};
