<?php
// database/migrations/2025_10_09_000001_add_spi_id_to_deposits.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('deposits', function (Blueprint $table) {
            if (! Schema::hasColumn('deposits', 'psp')) {
                $table->string('psp')->nullable()->index();
            }
            if (! Schema::hasColumn('deposits', 'stripe_payment_intent_id')) {
                $table->string('stripe_payment_intent_id')->nullable()->index();
            }
        });
    }

    public function down(): void
    {
        Schema::table('deposits', function (Blueprint $table) {
            if (Schema::hasColumn('deposits', 'stripe_payment_intent_id')) {
                $table->dropColumn('stripe_payment_intent_id');
            }
            if (Schema::hasColumn('deposits', 'psp')) {
                $table->dropColumn('psp');
            }
        });
    }
};
