<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::table('deposits', function (Blueprint $t) {
            if (!Schema::hasColumn('deposits','type')) {
                $t->string('type')->default('booking_deposit')->index();
            }
            if (!Schema::hasColumn('deposits','deposit_confirmed_at')) {
                $t->timestamp('deposit_confirmed_at')->nullable();
            }
        });
    }

    public function down(): void {
        Schema::table('deposits', function (Blueprint $t) {
            if (Schema::hasColumn('deposits','type')) {
                $t->dropColumn('type');
            }
            if (Schema::hasColumn('deposits','deposit_confirmed_at')) {
                $t->dropColumn('deposit_confirmed_at');
            }
        });
    }
};