<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (Schema::hasTable('bookings') && !Schema::hasColumn('bookings', 'vevs_car_id')) {
            Schema::table('bookings', function (Blueprint $t) {
                $t->string('vevs_car_id', 64)->nullable()->after('vehicle_id')->index();
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasTable('bookings') && Schema::hasColumn('bookings', 'vevs_car_id')) {
            Schema::table('bookings', function (Blueprint $t) {
                // Laravel infers the index name when created by column; this is safe:
                $t->dropIndex(['vevs_car_id']);
                $t->dropColumn('vevs_car_id');
            });
        }
    }
};
