<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (! Schema::hasTable('vevs_vehicles')) {
            Schema::create('vevs_vehicles', function (Blueprint $table) {
                $table->id();
                $table->string('vevs_car_id', 64)->unique();
                $table->string('name')->nullable();   // e.g. "Suzuki Jimny 5dr Auto"
                $table->string('label')->nullable();  // any shorter label if needed
                $table->string('type')->nullable();   // e.g. "SUV", "4WD" etc
                $table->json('raw')->nullable();      // full JSON row from VEVS
                $table->timestamps();
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasTable('vevs_vehicles')) {
            Schema::dropIfExists('vevs_vehicles');
        }
    }
};
