<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('jobs', function (Blueprint $table) {
            // simple text label, nullable
            if (! Schema::hasColumn('jobs', 'vehicle')) {
                $table->string('vehicle', 191)->nullable()->after('external_reference');
            }

            // raw VEVS car_id as string so it matches the feed
            if (! Schema::hasColumn('jobs', 'vevs_car_id')) {
                $table->string('vevs_car_id', 50)->nullable()->after('vehicle');
            }
        });
    }

    public function down(): void
    {
        Schema::table('jobs', function (Blueprint $table) {
            if (Schema::hasColumn('jobs', 'vevs_car_id')) {
                $table->dropColumn('vevs_car_id');
            }
            if (Schema::hasColumn('jobs', 'vehicle')) {
                $table->dropColumn('vehicle');
            }
        });
    }
};
