<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (! Schema::hasTable('vehicle_maintenance_logs')) {
            Schema::create('vehicle_maintenance_logs', function (Blueprint $table) {
                $table->id();

                // Keep it simple: just an indexed column, no FK constraint
                $table->unsignedBigInteger('vehicle_id')->index();

                // service / COF / repair / tyres / etc
                $table->string('type')->index();

                $table->string('title');               // e.g. "Full service", "COF passed"
                $table->text('description')->nullable();

                $table->integer('odometer_km')->nullable();
                $table->integer('cost_cents')->nullable();

                $table->date('performed_at');          // date work/inspection done
                $table->date('next_due_at')->nullable(); // next service/COF due

                $table->string('attachment_path')->nullable(); // invoice / COF pdf etc

                $table->timestamps();
            });
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('vehicle_maintenance_logs');
    }
};
