<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('vehicles', function (Blueprint $table) {
            // String name / display name
            if (! Schema::hasColumn('vehicles', 'name')) {
                $table->string('name')->nullable()->after('id');
            }

            // Registration
            if (! Schema::hasColumn('vehicles', 'registration')) {
                $table->string('registration', 50)->nullable()->after('name');
            }

            // Make / model / year / colour
            if (! Schema::hasColumn('vehicles', 'make')) {
                $table->string('make', 100)->nullable()->after('registration');
            }

            if (! Schema::hasColumn('vehicles', 'model')) {
                $table->string('model', 100)->nullable()->after('make');
            }

            if (! Schema::hasColumn('vehicles', 'year')) {
                $table->unsignedSmallInteger('year')->nullable()->after('model');
            }

            if (! Schema::hasColumn('vehicles', 'colour')) {
                $table->string('colour', 100)->nullable()->after('year');
            }

            // Active flag
            if (! Schema::hasColumn('vehicles', 'is_active')) {
                $table->boolean('is_active')->default(true)->after('colour');
            }

            // Seats
            if (! Schema::hasColumn('vehicles', 'seats')) {
                $table->unsignedTinyInteger('seats')->nullable()->after('is_active');
            }

            // Odometer
            if (! Schema::hasColumn('vehicles', 'odometer_km')) {
                $table->unsignedInteger('odometer_km')->nullable()->after('seats');
            }

            // Notes
            if (! Schema::hasColumn('vehicles', 'notes')) {
                $table->text('notes')->nullable()->after('odometer_km');
            }
        });
    }

    public function down(): void
    {
        Schema::table('vehicles', function (Blueprint $table) {
            // Only drop if you really want to roll back; safe to leave empty if unsure
            // $table->dropColumn([...]);
        });
    }
};
