<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('vehicles', function (Blueprint $table) {
            if (! Schema::hasColumn('vehicles', 'cof_due_at')) {
                $table->date('cof_due_at')->nullable()->after('odometer_km');
            }

            if (! Schema::hasColumn('vehicles', 'service_due_km')) {
                $table->unsignedInteger('service_due_km')->nullable()->after('cof_due_at');
            }

            if (! Schema::hasColumn('vehicles', 'rego_due_at')) {
                $table->date('rego_due_at')->nullable()->after('service_due_km');
            }
        });
    }

    public function down(): void
    {
        Schema::table('vehicles', function (Blueprint $table) {
            // Optional: drop columns on rollback
            // $table->dropColumn(['cof_due_at', 'service_due_km', 'rego_due_at']);
        });
    }
};
