<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('vehicles', function (Blueprint $table) {
            // Rego type (L / G etc)
            if (! Schema::hasColumn('vehicles', 'rego_type')) {
                $table->string('rego_type', 20)->nullable()->after('registration');
            }

            // RUC paid up to (km)
            if (! Schema::hasColumn('vehicles', 'ruc_paid_to_km')) {
                $table->unsignedInteger('ruc_paid_to_km')->nullable()->after('odometer_km');
            }

            // Service due date (in addition to service_due_km)
            if (! Schema::hasColumn('vehicles', 'service_due_at')) {
                $table->date('service_due_at')->nullable()->after('service_due_km');
            }

            // Lockbox & GPS details
            if (! Schema::hasColumn('vehicles', 'lockbox_code')) {
                $table->string('lockbox_code', 50)->nullable()->after('service_due_at');
            }

            if (! Schema::hasColumn('vehicles', 'gps_phone_number')) {
                $table->string('gps_phone_number', 50)->nullable()->after('lockbox_code');
            }

            if (! Schema::hasColumn('vehicles', 'gps_topup_note')) {
                $table->string('gps_topup_note')->nullable()->after('gps_phone_number');
            }

            // Insurance provider
            if (! Schema::hasColumn('vehicles', 'insurance_provider')) {
                $table->string('insurance_provider')->nullable()->after('gps_topup_note');
            }

            // Free-form notes like "Need to change rego type"
            if (! Schema::hasColumn('vehicles', 'appointments_note')) {
                $table->string('appointments_note')->nullable()->after('insurance_provider');
            }
        });
    }

    public function down(): void
    {
        Schema::table('vehicles', function (Blueprint $table) {
            // Optional: drop on rollback
            // $table->dropColumn([
            //     'rego_type',
            //     'ruc_paid_to_km',
            //     'service_due_at',
            //     'lockbox_code',
            //     'gps_phone_number',
            //     'gps_topup_note',
            //     'insurance_provider',
            //     'appointments_note',
            // ]);
        });
    }
};
