<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // Bail out if the table doesn't exist on this connection
        if (! Schema::hasTable('maintenance_logs')) {
            return;
        }

        Schema::table('maintenance_logs', function (Blueprint $table) {
            // Idempotent: only add if it doesn't exist
            if (! Schema::hasColumn('maintenance_logs', 'charge_owner')) {
                $table->boolean('charge_owner')
                    ->default(false)
                    ->after('total_cost_cents');
            }
        });
    }

    public function down(): void
    {
        if (! Schema::hasTable('maintenance_logs')) {
            return;
        }

        Schema::table('maintenance_logs', function (Blueprint $table) {
            if (Schema::hasColumn('maintenance_logs', 'charge_owner')) {
                $table->dropColumn('charge_owner');
            }
        });
    }
};
