<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('ops_tasks')) {
            return;
        }

        Schema::create('ops_tasks', function (Blueprint $table) {
            $table->id();

            $table->string('title');            // e.g. "Clean 02 inside"
            $table->text('notes')->nullable();

            // Links
            $table->foreignId('vehicle_id')
                ->nullable()
                ->constrained()
                ->nullOnDelete();

            $table->foreignId('job_id')
                ->nullable()
                ->constrained()
                ->nullOnDelete();

            // Optional brand scoping (future BrandContext)
            $table->unsignedBigInteger('brand_id')->nullable()->index();

            // Who is this task for (assignee)?
            $table->foreignId('for_user_id')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete();

            // Who created it?
            $table->foreignId('created_by_id')
                ->constrained('users');

            // Completion log
            $table->foreignId('completed_by_id')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete();

            // Meta
            $table->date('due_date')->nullable();              // often today
            $table->string('type')->default('other');          // cleaning / mechanical / admin / booking / other
            $table->unsignedTinyInteger('priority')->default(2); // 1=high,2=normal,3=low

            $table->timestamp('completed_at')->nullable();

            $table->timestamps();

            $table->index(['due_date', 'completed_at']);
            $table->index(['priority', 'completed_at']);
        });
    }

    public function down(): void
    {
        if (! Schema::hasTable('ops_tasks')) {
            return;
        }

        Schema::dropIfExists('ops_tasks');
    }
};
