<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('vehicles', function (Blueprint $table): void {
            if (! Schema::hasColumn('vehicles', 'ownership_type')) {
                $table->string('ownership_type')
                    ->default('company_owned')
                    ->after('id');
            }

            if (! Schema::hasColumn('vehicles', 'owner_id')) {
                $table->foreignId('owner_id')
                    ->nullable()
                    ->after('ownership_type')
                    ->constrained('owners')
                    ->nullOnDelete();
            }

            // Optional: JSON for future per-vehicle consignment tweaks
            if (! Schema::hasColumn('vehicles', 'consignment_terms')) {
                $table->json('consignment_terms')
                    ->nullable()
                    ->after('owner_id');
            }
        });
    }

    public function down(): void
    {
        Schema::table('vehicles', function (Blueprint $table): void {
            if (Schema::hasColumn('vehicles', 'consignment_terms')) {
                $table->dropColumn('consignment_terms');
            }

            if (Schema::hasColumn('vehicles', 'owner_id')) {
                $table->dropConstrainedForeignId('owner_id');
            }

            if (Schema::hasColumn('vehicles', 'ownership_type')) {
                $table->dropColumn('ownership_type');
            }
        });
    }
};
