<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('owner_ledger_entries')) {
            return;
        }

        Schema::create('owner_ledger_entries', function (Blueprint $table): void {
            $table->id();

            // Required – real FK to owners (this table *does* live in this DB)
            $table->foreignId('owner_id')
                ->constrained()
                ->cascadeOnDelete();

            // Optional – we just store IDs, no FK because vehicles live in another DB/context
            $table->unsignedBigInteger('vehicle_id')->nullable()->index();
            $table->unsignedBigInteger('job_id')->nullable()->index();

            $table->string('type', 50); // e.g. 'earning', 'payout', 'cost'
            $table->bigInteger('amount_cents');
            $table->string('currency_code', 3)->default('NZD');

            $table->string('description')->nullable();
            $table->timestamp('occurred_at')->nullable();

            $table->timestamps();
        });
    }

    public function down(): void
    {
        if (! Schema::hasTable('owner_ledger_entries')) {
            return;
        }

        Schema::drop('owner_ledger_entries');
    }
};
