<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // Table is vehicle_maintenance_logs (from VehicleMaintenanceLog model)
        if (! Schema::hasTable('vehicle_maintenance_logs')) {
            return;
        }

        Schema::table('vehicle_maintenance_logs', function (Blueprint $table): void {
            if (! Schema::hasColumn('vehicle_maintenance_logs', 'charge_to_owner')) {
                $table->boolean('charge_to_owner')
                    ->default(false)
                    ->after('cost_cents');
            }

            if (! Schema::hasColumn('vehicle_maintenance_logs', 'owner_cost_cents')) {
                $table->bigInteger('owner_cost_cents')
                    ->nullable()
                    ->after('charge_to_owner');
            }

            if (! Schema::hasColumn('vehicle_maintenance_logs', 'owner_cost_description')) {
                $table->string('owner_cost_description')
                    ->nullable()
                    ->after('owner_cost_cents');
            }
        });
    }

    public function down(): void
    {
        if (! Schema::hasTable('vehicle_maintenance_logs')) {
            return;
        }

        Schema::table('vehicle_maintenance_logs', function (Blueprint $table): void {
            foreach ([
                'charge_to_owner',
                'owner_cost_cents',
                'owner_cost_description',
            ] as $col) {
                if (Schema::hasColumn('vehicle_maintenance_logs', $col)) {
                    $table->dropColumn($col);
                }
            }
        });
    }
};
