<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('vehicle_maintenance_logs', function (Blueprint $table) {
            // Whether this maintenance item should be charged to the owner
            $table->boolean('charge_owner')
                ->default(false)
                ->after('cost_cents');

            // Link back to the owner_ledger_entries row (if any)
            $table->foreignId('owner_ledger_entry_id')
                ->nullable()
                ->after('charge_owner')
                ->constrained('owner_ledger_entries')
                ->nullOnDelete();
        });
    }

    public function down(): void
    {
        Schema::table('vehicle_maintenance_logs', function (Blueprint $table) {
            $table->dropConstrainedForeignId('owner_ledger_entry_id');
            $table->dropColumn('charge_owner');
        });
    }
};
