<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('vehicle_maintenance_logs', function (Blueprint $table) {
            $table->unsignedInteger('next_service_due_km')
                ->nullable()
                ->after('odometer_km');
        });
    }

    public function down(): void
    {
        Schema::table('vehicle_maintenance_logs', function (Blueprint $table) {
            $table->dropColumn('next_service_due_km');
        });
    }
};
