<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('jobs', function (Blueprint $table) {
            // Booking / source info
            if (! Schema::hasColumn('jobs', 'source_system')) {
                $table->string('source_system', 50)->nullable()->after('booking_id');
            }

            if (! Schema::hasColumn('jobs', 'pickup_location_id')) {
                $table->unsignedBigInteger('pickup_location_id')->nullable()->after('vehicle_id');
            }

            if (! Schema::hasColumn('jobs', 'return_location_id')) {
                $table->unsignedBigInteger('return_location_id')->nullable()->after('pickup_location_id');
            }

            if (! Schema::hasColumn('jobs', 'rental_days')) {
                $table->unsignedInteger('rental_days')->nullable()->after('end_at');
            }

            if (! Schema::hasColumn('jobs', 'rental_hours')) {
                $table->unsignedInteger('rental_hours')->nullable()->after('rental_days');
            }

            // Extended pricing (all cents)
            if (! Schema::hasColumn('jobs', 'tax_cents')) {
                $table->bigInteger('tax_cents')->nullable()->after('other_fees_cents');
            }

            if (! Schema::hasColumn('jobs', 'total_before_discount_cents')) {
                $table->bigInteger('total_before_discount_cents')->nullable()->after('total_price_cents');
            }

            if (! Schema::hasColumn('jobs', 'required_deposit_cents')) {
                $table->bigInteger('required_deposit_cents')->nullable()->after('total_before_discount_cents');
            }

            if (! Schema::hasColumn('jobs', 'security_deposit_cents')) {
                $table->bigInteger('security_deposit_cents')->nullable()->after('required_deposit_cents');
            }

            if (! Schema::hasColumn('jobs', 'vat_rate')) {
                $table->decimal('vat_rate', 5, 2)->nullable()->after('vat_cents');
            }

            if (! Schema::hasColumn('jobs', 'payment_method_external')) {
                $table->string('payment_method_external', 50)->nullable()->after('psp');
            }

            if (! Schema::hasColumn('jobs', 'external_status')) {
                $table->string('external_status', 50)->nullable()->after('status');
            }

            // Extended customer / drivers / travel
            if (! Schema::hasColumn('jobs', 'primary_driver_dob')) {
                $table->date('primary_driver_dob')->nullable()->after('customer_phone');
            }

            if (! Schema::hasColumn('jobs', 'primary_driver_licence')) {
                $table->string('primary_driver_licence', 120)->nullable()->after('primary_driver_dob');
            }

            if (! Schema::hasColumn('jobs', 'secondary_driver_name')) {
                $table->string('secondary_driver_name', 255)->nullable()->after('primary_driver_licence');
            }

            if (! Schema::hasColumn('jobs', 'secondary_driver_dob')) {
                $table->date('secondary_driver_dob')->nullable()->after('secondary_driver_name');
            }

            if (! Schema::hasColumn('jobs', 'secondary_driver_licence')) {
                $table->string('secondary_driver_licence', 120)->nullable()->after('secondary_driver_dob');
            }

            if (! Schema::hasColumn('jobs', 'flight_number')) {
                $table->string('flight_number', 50)->nullable()->after('secondary_driver_licence');
            }

            if (! Schema::hasColumn('jobs', 'airline')) {
                $table->string('airline', 120)->nullable()->after('flight_number');
            }

            if (! Schema::hasColumn('jobs', 'customer_notes')) {
                $table->text('customer_notes')->nullable()->after('airline');
            }

            // External payload JSON
            if (! Schema::hasColumn('jobs', 'external_payload')) {
                $table->json('external_payload')->nullable()->after('meta');
            }
        });
    }

    public function down(): void
    {
        Schema::table('jobs', function (Blueprint $table) {
            // Optional: you can leave this empty or drop with guards
            // if (Schema::hasColumn('jobs', 'source_system')) { $table->dropColumn('source_system'); }
        });
    }
};
