<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('jobs', function (Blueprint $table): void {
            if (! Schema::hasColumn('jobs', 'source_system')) {
                // Where to place it is up to you; after booking_reference is a sensible guess.
                $table->string('source_system', 50)
                    ->nullable()
                    ->after('booking_reference');
            }
        });
    }

    public function down(): void
    {
        Schema::table('jobs', function (Blueprint $table): void {
            if (Schema::hasColumn('jobs', 'source_system')) {
                $table->dropColumn('source_system');
            }
        });
    }
};
