<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (! Schema::hasColumn('vehicles', 'type')) {
            Schema::table('vehicles', function (Blueprint $table) {
                $table->string('type', 50)
                    ->nullable()
                    ->index()
                    ->after('id'); // or after whatever column makes sense
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasColumn('vehicles', 'type')) {
            Schema::table('vehicles', function (Blueprint $table) {
                $table->dropColumn('type');
            });
        }
    }
};
