<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (! Schema::hasTable('pricing_decisions')) {
            Schema::create('pricing_decisions', function (Blueprint $table) {
                $table->id();

                $table->string('brand', 50);             // jimny, dreamdrives, etc.
                $table->unsignedBigInteger('vehicle_id')->nullable();
                $table->string('vehicle_type', 100)->nullable(); // jimny_3door, suv, etc.

                $table->dateTime('pickup_at');
                $table->dateTime('return_at');

                $table->integer('daily_rate_cents');     // rate actually used
                $table->integer('total_cents');          // total for the stay

                $table->string('source', 100)->nullable(); // e.g. jimny_portal, dd_portal

                $table->json('context')->nullable();     // extra features / AI metadata later

                $table->timestamps();

                $table->index(['brand', 'pickup_at']);
                $table->index(['vehicle_id', 'pickup_at']);
            });
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('pricing_decisions');
    }
};
