<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
{
    Schema::create('booking_policies', function (Blueprint $table) {
        $table->id();
        $table->string('brand')->nullable();          // e.g. 'jimny', 'dreamdrives'
        $table->string('vehicle_type')->nullable();   // e.g. 'jimny_3door', 'jimny_5door'
        $table->unsignedInteger('min_lead_hours')->nullable();          // X hours from now
        $table->unsignedInteger('gap_between_bookings_hours')->nullable(); // Y hours between bookings
        $table->boolean('is_active')->default(true);
        $table->json('meta')->nullable();             // future flags
        $table->timestamps();
    });
}


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('booking_policies');
    }
};
