<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('customers', function (Blueprint $table) {
            // Add first_name if it doesn't exist
            if (! Schema::hasColumn('customers', 'first_name')) {
                $table->string('first_name')->nullable()->after('id');
            }

            // Add last_name if it doesn't exist
            if (! Schema::hasColumn('customers', 'last_name')) {
                $table->string('last_name')->nullable()->after('first_name');
            }
        });
    }

    public function down(): void
    {
        Schema::table('customers', function (Blueprint $table) {
            if (Schema::hasColumn('customers', 'first_name')) {
                $table->dropColumn('first_name');
            }

            if (Schema::hasColumn('customers', 'last_name')) {
                $table->dropColumn('last_name');
            }
        });
    }
};
