<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('bookings', function (Blueprint $table) {
            // Only add if it doesn't already exist
            if (! Schema::hasColumn('bookings', 'brand')) {
                $table->string('brand', 50)
                    ->nullable()
                    ->after('reference'); // adjust position if you prefer
            }
        });
    }

    public function down(): void
    {
        Schema::table('bookings', function (Blueprint $table) {
            if (Schema::hasColumn('bookings', 'brand')) {
                $table->dropColumn('brand');
            }
        });
    }
};
