<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('bookings', function (Blueprint $table) {
            // Amounts are stored in cents (integers)
            if (! Schema::hasColumn('bookings', 'total_amount')) {
                $table->bigInteger('total_amount')
                    ->nullable()
                    ->after('end_at');
            }

            if (! Schema::hasColumn('bookings', 'deposit_amount')) {
                $table->bigInteger('deposit_amount')
                    ->nullable()
                    ->after('total_amount');
            }

            if (! Schema::hasColumn('bookings', 'hold_amount')) {
                $table->bigInteger('hold_amount')
                    ->nullable()
                    ->after('deposit_amount');
            }

            if (! Schema::hasColumn('bookings', 'currency')) {
                $table->string('currency', 3)
                    ->default('NZD')
                    ->after('hold_amount');
            }

            if (! Schema::hasColumn('bookings', 'status')) {
                $table->string('status', 50)
                    ->default('pending')
                    ->after('currency');
            }

            if (! Schema::hasColumn('bookings', 'portal_token')) {
                $table->string('portal_token', 100)
                    ->nullable()
                    ->after('status');
            }
        });
    }

    public function down(): void
    {
        Schema::table('bookings', function (Blueprint $table) {
            if (Schema::hasColumn('bookings', 'portal_token')) {
                $table->dropColumn('portal_token');
            }

            if (Schema::hasColumn('bookings', 'status')) {
                $table->dropColumn('status');
            }

            if (Schema::hasColumn('bookings', 'currency')) {
                $table->dropColumn('currency');
            }

            if (Schema::hasColumn('bookings', 'hold_amount')) {
                $table->dropColumn('hold_amount');
            }

            if (Schema::hasColumn('bookings', 'deposit_amount')) {
                $table->dropColumn('deposit_amount');
            }

            if (Schema::hasColumn('bookings', 'total_amount')) {
                $table->dropColumn('total_amount');
            }
        });
    }
};
