<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (! Schema::hasColumn('jobs', 'booking_reference')) {
            Schema::table('jobs', function (Blueprint $table) {
                $table->string('booking_reference', 191)
                    ->nullable()
                    ->after('id')
                    ->index();
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasColumn('jobs', 'booking_reference')) {
            Schema::table('jobs', function (Blueprint $table) {
                $table->dropColumn('booking_reference');
            });
        }
    }
};
